<?php
/**
 * ioncube_error_handler.
 * Create a more friendly ionCube related error
 */
class hostfact_error_handler{

    public static $ioncube_error_handler = true;

    public static function ioncube_error_handler()
    {
        // First check if we are allowed to catch these errors.
        if(self::$ioncube_error_handler === false)
        {
            return;
        }

        // Get latest PHP error.
        $error = error_get_last();

        // Check type of error.
        if($error === null || !in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_USER_ERROR]))
        {
            return;
        }

        // Prepare message for ionCube related messages.
        $error_title = $error_message = '';

        // Search for missing ionCube loader-messages
        if(strpos(strtolower($error['message']), 'ioncube php loader needs to be installed') !== false)
        {
            $error_title = 'ionCube loader niet geïnstalleerd op PHP '.phpversion().'.';
            $error_message = 'Vraag uw serverbeheerder om een recente ionCube loader te installeren voor PHP '.phpversion().' op uw server. Meer informatie is te vinden op: <a href="http://www.ioncube.com/loaders.php">http://www.ioncube.com/loaders.php</a>';
        }
        // Search for PHP version and ionCube version conflicts
        elseif(strpos(strtolower($error['message']), 'ioncube') !== false)
        {
            $error_title = 'Uw HostFact bestanden zijn niet gecodeerd voor PHP '.phpversion().'.';
            $error_message = 'Dit kan 2 oorzaken hebben:<br /><ol><li>
HostFact is niet geschikt voor PHP '.phpversion().'. <a href="https://www.hostfact.nl/help/artikel/61/server-eisen/" target="_blank">Bekijk hier de server eisen</a>.</li><li>
U heeft niet de juiste HostFact bestanden. U kunt de PHP '.phpversion().' bestanden downloaden via <a href="https://www.hostfact.nl/klanten/" target="_blank">onze website</a>.</li></ol><br /><br /><strong>ionCube foutmelding:</strong><br />'.$error['message'];
        }

        if($error_title && $error_message) {

            die('<html><head><title>ionCube foutmelding</title><style type="text/css">body{margin:40px;font-family:Verdana;font-size:12px;color:#000;}#content{border:1px solid #999;background-color:#fff;padding: 25px;width:600px;position:absolute;left:50%;margin-left:-300px;}a{color:#000099;}h1{font-weight:normal;font-size:14px;font-weight:bold;margin:0 0 4px 0;}</style></head><body><div id="content"><h1>' . $error_title . '</h1>' . $error_message . '</div></body></html>');
        }

    }
}

// Register ioncube_error_handler
register_shutdown_function( ['hostfact_error_handler','ioncube_error_handler']);

// For missing ionCube loaders
if(!extension_loaded('ionCube Loader'))
{
    trigger_error('ionCube PHP Loader needs to be installed', E_USER_ERROR);
}

// Load dashboard
require_once 'index_dashboard.php';