<?php

class CST_Controller extends OrderForm_Controller
{
    public function __construct()
    {
        // Load parent constructor
        parent::__construct();

        // Create instances of uses objects
        $this->cst 	= new CST_Model();
        global $orderform_settings;
        $this->orderform_settings = $orderform_settings->OtherSettings->cst;
        $this->set('orderform_settings', $this->orderform_settings);

        // Set theme information
        if($this->orderform_settings->Theme == 'packages')
        {
            define("PACKAGES_GRID",			(isset($this->orderform_settings->PackagesGrid)) ? $this->orderform_settings->PackagesGrid : 4); // 4 | 3 | 2 | 1

            $package_descriptions = array();

            if(isset($this->orderform_settings->PackagesDescription)){
                foreach($this->orderform_settings->PackagesDescription as $prod_id => $prod_desc){
                    $package_descriptions[$prod_id] = $prod_desc;
                }
            }

            $this->set('package_descriptions', $package_descriptions);
        }
        elseif($this->orderform_settings->Theme == 'compare')
        {
            $compare_matrix = array();
            $compare_matrix['legend'] = $this->orderform_settings->CompareLabels;

            if(isset($this->orderform_settings->CompareValues)){
                foreach($this->orderform_settings->CompareValues as $prod_id => $prod_values){
                    $compare_matrix[$prod_id] = $prod_values;
                }
            }

            $this->set('compare_matrix', $compare_matrix);
        }

        // Default values
        if($this->orderform_settings->DefaultProduct && $this->cst->getItem('CST') === false)
        {
            // Default CST package
            $this->cst->newItem('CST');
            $this->cst->setAttribute('ProductCode', $this->orderform_settings->DefaultProduct);
            $this->cst->saveItem();
        }
    }

    function start()
    {
        // Check also for GET variables
        if(isset($_GET['cst']))
        {
            $this->cst->newItem('CST');
            $this->cst->setAttribute('ProductCode', $_GET['cst']);
            $this->cst->saveItem();
        }

        // Default orderform doesn't have an extra step
        return $this->details();
    }

    function details()
    {
        // Get products and pass to view
        global $orderform_settings;
        $list_products = $this->cst->getProductsFromGroup($orderform_settings->ProductGroups->cst);

        $this->set('list_products', $list_products);

        // Get CST type settings.
        $cstTypeRecord = $this->cst->getType($orderform_settings->OtherSettings->cst->Type);
        $this->set('cstTypeRecord', $cstTypeRecord);

        // Handling options
        $this->__handleOptions();

        // Handle other POST data from form
        if(isset($_POST['step']))
        {
            // Store product in session
            // Set period
            if(PERIOD_CHOICE == 'yes' && isset($_POST['BillingPeriod']))
            {
                $this->order->set('PricePeriod', $_POST['BillingPeriod']);
            }

            // Add new CST product
            $this->cst->newItem('CST');
            $this->cst->setAttribute('Name', (isset($_POST['Name'])) ? $_POST['Name'] : '');
            $this->cst->setAttribute('Number', (isset($_POST['Number']) && is_numeric($_POST['Number'])) ? (int)$_POST['Number'] : 1);
            $this->cst->setAttribute('ProductCode', (isset($_POST['CST'])) ? $_POST['CST'] : '');

            $customfields_list = $this->cst->getCustomFields(sprintf('cst-%d', $cstTypeRecord->id));

            $validation = CustomClientFields_Model::validateCustomFieldValues($customfields_list, $_POST['Custom']);
            if (is_array($validation)) {
                $this->Error = array_merge($this->Error, $validation);
            } else {
                $this->cst->setAttribute('Custom', CustomClientFields_Model::convertCustomFieldValues($customfields_list, $_POST['Custom'], true));
            }

            $this->cst->saveItem();

            // We do offcourse need a product code to be selected
            if(!isset($_POST['CST']) || !$_POST['CST'])
            {
                $this->Error[] = __('you need to select a product');
            }
            else
            {
                // Validate entered CST data with the validate() function in CST_Model
                if(!$this->cst->validate($cstTypeRecord))
                {
                    // There is some invalid data, merge error
                    $this->Error = array_merge($this->Error, $this->cst->Error);
                }
            }

            // Depending on errors, go to next step or display same page again
            if(empty($this->Error))
            {
                // If we don't have any errors, go to the next step
                unset($_POST['step']);
                return $this->customer();
            }
            else
            {
                // Display same page again, but pass errors to view
                $this->set('errors', $this->Error);
            }
        }

        // Get elements in session and pass to view
        $element_list = $this->cst->listItems();

        $cst = isset($element_list['CST']) ? $element_list['CST'] : array();
        $this->set('cst', $cst);
        if(isset($cst['ProductCode']) && $cst['ProductCode'])
        {
            $product_info = $this->cst->getProductInfo($cst['ProductCode']);
            $this->set('product_info', $product_info);
        }

        // Get other elements in session and pass to view
        $element_list = $this->element->listItems();
        $this->set('element_list', $element_list);

        // Pass order instance to view
        $this->set('order',  $this->order->show());

        // Load view
        $this->display('details.phtml');
    }

    function getCart($escaped = true)
    {
        // Add all different elements to order object, in the following order: cst/other
        $this->order->elements = array();

        // Get CST
        $element_list = $this->cst->listItems($escaped);
        foreach($element_list as $cst => $cst_info)
        {
            // Add element into order
            $this->order->addElement($cst_info);
        }

        // Get other items
        $element_list = $this->element->listItems($escaped);
        foreach($element_list as $element => $element_info)
        {
            // Add element into order
            $this->order->addElement($element_info);
        }
    }
}
