<?php

// Require to load the generic Mollie payment module.
try {
    $mollie_module = dirname(__FILE__, 2) . '/mollie/payment_provider.php';
    require_once($mollie_module);
} catch (Exception $e) {
    exit(sprintf('Mollie bancontact requires the generic Mollie payment method in: %s', $mollie_module));
}

class mollie_bancontact extends mollie
{
    protected const PAYMENT_METHOD_CODE = 'bancontact';

    protected function loadConfiguration()
    {
        $this->conf['PaymentDirectory'] = 'mollie.bancontact';
        $this->conf['PaymentMethod'] = 'other';
    }

    public static function getBackofficeSettings()
    {
        $settings = parent::getBackofficeSettings();

        $settings['InternalName'] = 'Mollie - Bancontact';
        $settings['Advanced']['Title'] = "Bancontact";
        $settings['Advanced']['Image'] = "bancontact.png";
        $settings['Advanced']['Description'] = "U kunt via Bancontact uw bestelling betalen via internetbankieren van uw eigen bank.";

        $settings['Advanced']['Extra'] = "";

        return $settings;
    }

    public function choosePaymentMethod()
    {
        return false;
    }

    public function validateChosenPaymentMethod()
    {
        return true;
    }
}
