<?php

// Require to load the generic Mollie payment module.
try {
    $mollie_module = dirname(__FILE__, 2) . '/mollie/payment_provider.php';
    require_once($mollie_module);
} catch (Exception $e) {
    exit(sprintf('Mollie creditcard requires the generic Mollie payment method in: %s', $mollie_module));
}

class mollie_creditcard extends mollie
{
    protected const PAYMENT_METHOD_CODE = 'creditcard';

    protected function loadConfiguration()
    {
        $this->conf['PaymentDirectory'] = 'mollie.creditcard';
        $this->conf['PaymentMethod'] = 'other';
    }

    public static function getBackofficeSettings()
    {
        $settings = parent::getBackofficeSettings();

        $settings['InternalName'] = 'Mollie - Creditcard';
        $settings['Advanced']['Title'] = "Creditcard";
        $settings['Advanced']['Image'] = "creditcard.png";
        $settings['Advanced']['Description'] = "U kunt uw bestelling betalen via creditcard.";

        $settings['Advanced']['Extra'] = "";

        return $settings;
    }

    public function choosePaymentMethod()
    {
        return false;
    }

    public function validateChosenPaymentMethod()
    {
        return true;
    }
}
