<?php

// Require to load the generic Mollie payment module.
try {
    $mollie_module = dirname(__FILE__, 2) . '/mollie/payment_provider.php';
    require_once($mollie_module);
} catch (Exception $e) {
    exit(sprintf('Mollie ideal requires the generic Mollie payment method in: %s', $mollie_module));
}

class mollie_ideal extends mollie
{
    protected const PAYMENT_METHOD_CODE = 'ideal';

    protected function loadConfiguration()
    {
        $this->conf['PaymentDirectory'] = 'mollie.ideal';
        $this->conf['PaymentMethod'] = 'ideal';
    }

    public static function getBackofficeSettings()
    {
        $settings = parent::getBackofficeSettings();

        $settings['InternalName'] = 'Mollie - iDEAL';
        $settings['Advanced']['Title'] = "iDEAL";
        $settings['Advanced']['Image'] = "ideal.png";
        $settings['Advanced']['Description'] = "Met iDEAL kunt u vertrouwd, veilig en gemakkelijk uw online aankopen afrekenen.";

        $settings['Advanced']['Extra'] = "";

        return $settings;
    }

    public function choosePaymentMethod()
    {
        return false;
    }

    public function validateChosenPaymentMethod()
    {
        return true;
    }
}
