<?php

// Require to load the generic PayNL payment module.
try {
    $paynl_module = dirname(__FILE__, 2) . '/paynl/payment_provider.php';
    require_once($paynl_module);
} catch (Exception $e) {
    exit(sprintf('PayNL bancontact requires the generic PayNL payment method in: %s', $paynl_module));
}

class paynl_bancontact extends paynl
{
    protected const PAYMENT_METHOD_ID = 436;

    protected function loadConfiguration()
    {
        $this->conf['PaymentDirectory'] = 'paynl.bancontact';
        $this->conf['PaymentMethod'] = 'other';
    }

    public static function getBackofficeSettings()
    {
        $settings = parent::getBackofficeSettings();

        $settings['InternalName'] = 'Pay.nl - Bancontact';
        $settings['Advanced']['Title'] = "Bancontact";
        $settings['Advanced']['Image'] = "bancontact.png";
        $settings['Advanced']['Description'] = "U kunt via Bancontact uw bestelling betalen via internetbankieren van uw eigen bank.";

        $settings['Advanced']['Extra'] = "";

        return $settings;
    }

    public function choosePaymentMethod()
    {
        return false;
    }

    public function validateChosenPaymentMethod()
    {
        return true;
    }
}
