<?php
/**
 * This is a core PHP file. For customization, create a file in the folder /custom/.
 * Files with the same filename in this folder will automatically be loaded instead of the current file
 */

namespace hostfact;

use Hook;
use Settings_Model;


class CST
{
	public $ClassName;

	public $UrlString;

	public function __construct()
	{
		// strip the namespace
		$this->ClassName = implode('', array_slice(explode('\\', __CLASS__), -1));

		// call hooks
		Hook::addFilter('main_menu', array(__NAMESPACE__, $this->ClassName, 'filter_main_menu'));
		Hook::addFilter('service_page', array(__NAMESPACE__, $this->ClassName, 'filter_service_page'));
		Hook::addFilter('home_services', array(__NAMESPACE__, $this->ClassName, 'filter_home_services'));
		Hook::addFilter('services_orderform', array(__NAMESPACE__, $this->ClassName, 'filter_services_orderform'));
	}

	function filter_main_menu($main_menu, $parameters)
	{
		// First check if we have cst at all
		$cstModel = new CST_Model;
        [$list_cst, $list_types] = $cstModel->listCST();

		if(empty($list_cst))
		{
			// No cst, do not extend menu
			return $main_menu;
		}

        // add plugin url's to active state for services
        array_push($main_menu['services']['active'], 'cst');

        foreach($list_types as $type) {
            $count = count(array_filter($list_cst, function($cst) use ($type){ return $cst['Type'] == $type['id']; }));
            if ($count) {
                // add to main menu, as child of services
                $main_menu['services']['children'][sprintf('cst-%d', $type['id'])] = array('title'  => $type['Name'],
                    'url'    => __SITE_URL . '/' . __('cst', 'url', __CLASS__) . '/' . $type['id'],
                    'active' => array(sprintf('cst-%d', $type['id'])));
            }
        }

		return $main_menu;
	}

	function filter_service_page($services, \Template $template)
	{
		// First check if we have cst at all
		$cstModel = new CST_Model;
        [$list_cst, $list_types] = $cstModel->listCST();

		if(empty($list_cst))
		{
			// No cst, do not extend services
			return $services;
		}

		// Extend list of services to display
		$services['cst'] = array('element' => 'cst.table',
								 'title' => __('mainmenu cst', __CLASS__),
								 'pluginName' => __CLASS__);

		// Put variables in template
		$template->list_cst = $list_cst;
        $template->list_types = $list_types;

		return $services;
	}

	function filter_home_services($services)
	{
		// First check if we have cst at all
		$cstModel = new CST_Model;
		[$list_cst, $list_types] = $cstModel->listCST();

		if(empty($list_cst))
		{
			// No cst, do not extend services
			return $services;
		}

        foreach($list_types as $type) {
            $count = count(array_filter($list_cst, function($cst) use ($type){ return $cst['Type'] == $type['id']; }));
            if ($count) {
                // Extend list of services to display
                $services[sprintf('cst-%d', $type['id'])] = array('amount' => $count,
                    'service_label'     => $type['Name'],
                    'services_label'    => $type['Name'],
                    'url_services_page' => __SITE_URL . '/' . __('cst', 'url', __CLASS__) . '/' . $type['id'],
                    'pluginName'        => __CLASS__);
            }
        }

		return $services;
	}

	function filter_services_orderform($services)
	{
        return $services;
	}

	/**
	 * Set the url name for the plugin name here
	 */
	function setUrlString()
	{
		$this->UrlString = __('cst', 'url', __CLASS__);
	}


	/** function determines if the plugin should be activated (TRUE) or not (FALSE)
	 *
	 * @return bool
	 */
	function activatePlugin()
	{
		// retrieve the setting which indicates which service modules are active
		$active_service_modules = Settings_Model::get('ACTIVE_SERVICE_MODULES');
		// only when the module is active, do we want to activate the plugin
		if(	$active_service_modules && is_array($active_service_modules) && in_array('cst', $active_service_modules))
		{
			return TRUE;
		}

		return FALSE;
	}

	/**
	 * Extend initial calls
	 * @param $cache_calls
	 * @return array
	 */
	function extendInitialMultiCall($cache_calls)
	{
		$cache_calls[] = array('controller' => 'cst', 'action' => 'list', 'params' => array('status' => 'active|suspended|error'), 'options' => array('cacheable' => TRUE));
		return $cache_calls;
	}
}

return __NAMESPACE__;